/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.util.Iterator;
import org.apache.sis.util.ObjectConverter;

final class DerivedIterator<S, E>
implements Iterator<E> {
    private final Iterator<S> iterator;
    private final ObjectConverter<S, E> converter;
    private transient E next;

    DerivedIterator(Iterator<S> iterator, ObjectConverter<S, E> objectConverter) {
        this.iterator = iterator;
        this.converter = objectConverter;
    }

    @Override
    public boolean hasNext() {
        while (this.next == null) {
            if (!this.iterator.hasNext()) {
                return false;
            }
            this.next = this.converter.apply(this.iterator.next());
        }
        return true;
    }

    @Override
    public E next() {
        E e = this.next;
        this.next = null;
        while (e == null) {
            e = this.converter.apply(this.iterator.next());
        }
        return e;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

