#!/usr/bin/perl

use Test;
BEGIN { plan tests => 13 }

########################################################################

package MyObject;

use Class::MakeMethods::Autoload { 
  'new'     => 'Standard::Hash::new', 
  '.*'      => 'Standard::Hash::scalar',
  'DESTROY' => 'Standard::Universal::no_op',
};

########################################################################

package main;

ok( 1 );

# Constructor: new()
ok( ref MyObject->can('new') ne 'CODE' );
ok( $obj_1 = MyObject->new() );
ok( ref MyObject->can('new') eq 'CODE' );
ok( ref $obj_1 eq 'MyObject' );

# Method doesn't exist yet
ok( ! $obj_1->can('a') );

# Autogenerated on first use
ok( ! defined $obj_1->a() );
ok( $obj_1->a('Apple') );
ok( $obj_1->a() eq 'Apple' );

# Method now generally visible
ok( ref $obj_1->can('a') eq 'CODE' );

# Another method
ok( ! defined $obj_1->b() );
ok( $obj_1->b('Be') );
ok( $obj_1->b() eq 'Be' );

1;
