# Generated by default/object.tt
package Paws::IoTWireless::LoRaWANGateway;
  use Moose;
  has GatewayEui => (is => 'ro', isa => 'Str');
  has JoinEuiFilters => (is => 'ro', isa => 'ArrayRef[ArrayRef[Str|Undef]]');
  has NetIdFilters => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has RfRegion => (is => 'ro', isa => 'Str');
  has SubBands => (is => 'ro', isa => 'ArrayRef[Int]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTWireless::LoRaWANGateway

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTWireless::LoRaWANGateway object:

  $service_obj->Method(Att1 => { GatewayEui => $value, ..., SubBands => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTWireless::LoRaWANGateway object:

  $result = $service_obj->Method(...);
  $result->Att1->GatewayEui

=head1 DESCRIPTION

LoRaWANGateway object.

=head1 ATTRIBUTES


=head2 GatewayEui => Str

The gateway's EUI value.


=head2 JoinEuiFilters => ArrayRef[ArrayRef[Str|Undef]]




=head2 NetIdFilters => ArrayRef[Str|Undef]




=head2 RfRegion => Str

The frequency band (RFRegion) value.


=head2 SubBands => ArrayRef[Int]





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTWireless>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

