#!perl
use strict;
use vars qw( $DEBUG );
$DEBUG = exists( $ENV{AUTHOR_TESTING} ) ? $ENV{AUTHOR_TESTING} : 0;

print "1..3\n";

use Data::Pretty qw(dump);
local $Data::Pretty::DEBUG = $DEBUG;

my $a = 42;
my @a = (\$a);

my $d = dump($a, $a, \$a, \\$a, "$a", $a+0, \@a);

print "$d;\n";

print "not " unless $d eq q(do {
  my $a = 42;
  ($a, $a, \\$a, \\\\$a, 42, 42, [\\$a]);
});
print "ok 1\n";

$d = dump(\\$a, \$a, $a, \@a);
print "$d;\n";

print "not " unless $d eq q(do {
  my $a = \\\\42;
  ($a, $$a, $$$a, [$$a]);
});
print "ok 2\n";

# not really a scalar test, but anyway
$a = [];
$d = dump(\$a, $a);

print "$d;\n";
print "not " unless $d eq q(do {
  my $a = \[];
  ($a, $$a);
});
print "ok 3\n";
