# Generated by default/object.tt
package Paws::AccessAnalyzer::KmsGrantConfiguration;
  use Moose;
  has Constraints => (is => 'ro', isa => 'Paws::AccessAnalyzer::KmsGrantConstraints', request_name => 'constraints', traits => ['NameInRequest']);
  has GranteePrincipal => (is => 'ro', isa => 'Str', request_name => 'granteePrincipal', traits => ['NameInRequest'], required => 1);
  has IssuingAccount => (is => 'ro', isa => 'Str', request_name => 'issuingAccount', traits => ['NameInRequest'], required => 1);
  has Operations => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'operations', traits => ['NameInRequest'], required => 1);
  has RetiringPrincipal => (is => 'ro', isa => 'Str', request_name => 'retiringPrincipal', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AccessAnalyzer::KmsGrantConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AccessAnalyzer::KmsGrantConfiguration object:

  $service_obj->Method(Att1 => { Constraints => $value, ..., RetiringPrincipal => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AccessAnalyzer::KmsGrantConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->Constraints

=head1 DESCRIPTION

A proposed grant configuration for a KMS key. For more information, see
CreateGrant
(https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html).

=head1 ATTRIBUTES


=head2 Constraints => L<Paws::AccessAnalyzer::KmsGrantConstraints>

Use this structure to propose allowing cryptographic operations
(https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations)
in the grant only when the operation request includes the specified
encryption context
(https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context).


=head2 B<REQUIRED> GranteePrincipal => Str

The principal that is given permission to perform the operations that
the grant permits.


=head2 B<REQUIRED> IssuingAccount => Str

The AWS account under which the grant was issued. The account is used
to propose KMS grants issued by accounts other than the owner of the
key.


=head2 B<REQUIRED> Operations => ArrayRef[Str|Undef]

A list of operations that the grant permits.


=head2 RetiringPrincipal => Str

The principal that is given permission to retire the grant by using
RetireGrant
(https://docs.aws.amazon.com/kms/latest/APIReference/API_RetireGrant.html)
operation.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AccessAnalyzer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

