# Generated by default/object.tt
package Paws::AmplifyBackend::UpdateBackendAuthOAuthConfig;
  use Moose;
  has DomainPrefix => (is => 'ro', isa => 'Str', request_name => 'domainPrefix', traits => ['NameInRequest']);
  has OAuthGrantType => (is => 'ro', isa => 'Str', request_name => 'oAuthGrantType', traits => ['NameInRequest']);
  has OAuthScopes => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'oAuthScopes', traits => ['NameInRequest']);
  has RedirectSignInURIs => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'redirectSignInURIs', traits => ['NameInRequest']);
  has RedirectSignOutURIs => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'redirectSignOutURIs', traits => ['NameInRequest']);
  has SocialProviderSettings => (is => 'ro', isa => 'Paws::AmplifyBackend::SocialProviderSettings', request_name => 'socialProviderSettings', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AmplifyBackend::UpdateBackendAuthOAuthConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AmplifyBackend::UpdateBackendAuthOAuthConfig object:

  $service_obj->Method(Att1 => { DomainPrefix => $value, ..., SocialProviderSettings => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AmplifyBackend::UpdateBackendAuthOAuthConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->DomainPrefix

=head1 DESCRIPTION

The OAuth configurations for authenticating users into your Amplify
app.

=head1 ATTRIBUTES


=head2 DomainPrefix => Str

The Amazon Cognito domain prefix used to create a hosted UI for
authentication.


=head2 OAuthGrantType => Str

The OAuth grant type to allow app users to authenticate from your
Amplify app.


=head2 OAuthScopes => ArrayRef[Str|Undef]

The list of OAuth-related flows that can allow users to authenticate
from your Amplify app.


=head2 RedirectSignInURIs => ArrayRef[Str|Undef]

Redirect URLs used by OAuth when a user signs in to an Amplify app.


=head2 RedirectSignOutURIs => ArrayRef[Str|Undef]

Redirect URLs used by OAuth when a user signs out of an Amplify app.


=head2 SocialProviderSettings => L<Paws::AmplifyBackend::SocialProviderSettings>

Describes third-party social federation configurations for allowing
your users to sign in with OAuth.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AmplifyBackend>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

