# Generated by default/object.tt
package Paws::NetworkFirewall::Dimension;
  use Moose;
  has Value => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::NetworkFirewall::Dimension

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::NetworkFirewall::Dimension object:

  $service_obj->Method(Att1 => { Value => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::NetworkFirewall::Dimension object:

  $result = $service_obj->Method(...);
  $result->Att1->Value

=head1 DESCRIPTION

The value to use in an Amazon CloudWatch custom metric dimension. This
is used in the C<PublishMetrics> CustomAction. A CloudWatch custom
metric dimension is a name/value pair that's part of the identity of a
metric.

AWS Network Firewall sets the dimension name to C<CustomAction> and you
provide the dimension value.

For more information about CloudWatch custom metric dimensions, see
Publishing Custom Metrics
(https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html#usingDimensions)
in the Amazon CloudWatch User Guide
(https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/WhatIsCloudWatch.html).

=head1 ATTRIBUTES


=head2 B<REQUIRED> Value => Str

The value to use in the custom metric dimension.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::NetworkFirewall>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

